document.addEventListener("DOMContentLoaded", function () {
  const pageContainer = document.querySelector(".page-container");
  const inputUserName = document.getElementById("username-input");
  const inputPassWd = document.getElementById("password-input");
  const inputRePassWd = document.getElementById("repassword-input");

  // 给「注册心火账号」按钮绑定点击事件
  document.getElementById("xh_back_btn").addEventListener("click", function () {
    // 在当前窗口跳转（覆盖原页面，适合移动端）
    window.location.href = "register.html";
  });

  // 注册按钮
  document
    .getElementById("xh_register_btn")
    .addEventListener("click", doRegister);

  inputUserName.addEventListener("input", function () {
    const isLegal = checkLenth(this.value, 0);
    if (!isLegal) {
      showToast("用户名需要输入3-20个字符");
    }
  });

  inputPassWd.addEventListener("input", function () {
    const isLegal = checkLenth(this.value, 0);
    if (!isLegal) {
      showToast("密码需要输入6-20个字符");
    }
  });

  // 检查字符串合法,只允许数字/a-z/A_Z
  function checkStrValid(value) {
    const reg = /^[0-9a-zA-Z]*$/;
    return reg.test(value);
  }

  // 检查长度
  function checkLenth(value, minLen) {
    if (!value.trim()) {
      return false;
    }

    if (value.length < minLen) {
      return false;
    } else if (value.length > 20) {
      return false;
    }
    return true;
  }

  // 核心函数：计算并设置 viewport width 为 min(590, 100vw)
  function setViewportMinWidth() {
    const baseWidth = 590;
    const baseHeight = 610;
    const maxWidth1 = window.innerWidth;
    const maxWidth2 = (window.innerHeight * baseWidth) / baseHeight;
    const width = Math.min(baseWidth, Math.min(maxWidth1, maxWidth2));
    // 构造 viewport 配置（禁用缩放，避免干扰）
    const viewportContent = `width=${width}, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, user-scalable=no, viewport-fit=cover`;
    // 赋值给 viewport 标签
    document.getElementById("viewportMeta").content = viewportContent;
    // console.log('当前 viewport 宽度:', width);
  }

  // 页面加载完成后执行
  window.addEventListener("load", setViewportMinWidth);
  // 窗口/ WebView 尺寸变化时实时更新（如旋转屏幕、调整 WebView 大小）
  window.addEventListener("resize", setViewportMinWidth);
  // 屏幕旋转后更新（兼容移动端）
  window.addEventListener("orientationchange", setViewportMinWidth);

  // 提示框控制函数（复用，支持自定义文本）
  const toast = document.getElementById("toast");
  function showToast(text, duration = 2000) {
    toast.textContent = text; // 设置提示文本
    toast.classList.add("show"); // 显示提示框

    // 自动隐藏（duration 毫秒后，默认2秒）
    setTimeout(() => {
      toast.classList.remove("show");
    }, duration);
  }

  async function doRegister() {
    if (!checkLenth(inputUserName.value, 3)) {
      showToast("用户名需要输入3-20个字符");
      return;
    }

    if (!checkLenth(inputPassWd.value, 6)) {
      showToast("密码需要输入6-20个字符");
      return;
    }

    if (!checkStrValid(inputUserName.value)) {
      showToast("用户名只能输入数字和大小写字母");
      return;
    }

    if (!checkStrValid(inputPassWd.value)) {
      showToast("密码只能输入数字和大小写字母");
      return;
    }

    if ((inputPassWd.value === inputRePassWd.value) === false) {
      showToast("两次输入密码不一致,请核对!!!");
      return;
    }

    // 接后端创建角色
    if (await sendRegisterRequest(inputUserName.value, inputPassWd.value)) {
      setTimeout(() => {
        // 在当前窗口跳转（覆盖原页面，适合移动端）
            window.location.href = `login_xh.html?userName=${inputUserName.value}&passwd=${inputPassWd.value}&auto=0`;
        }, 800);
    }
  }

  // 发送注册 GET 请求（核心）
  async function sendRegisterRequest(user, passwd) {
    // 后端接口地址（替换为你的真实后端 URL）
    const urlBase = HttpUtils.baseUrl();
    const url = `${urlBase}user/register`;
    const params = {
      userName: encodeURIComponent(user),
      passwd: encodeURIComponent(passwd),
    };
    const responseJson = await HttpUtils.get(url, params);

    if (responseJson.status === 0) {
      showToast("Register Success");
      return true;
    }
    showToast(`Register Failed, ${responseJson.message}`);
    return false;
  }

  // -------------- 禁用开发者工具 --------------
  // 禁止右键菜单（防止查看源代码）
  document.addEventListener("contextmenu", function (e) {
    e.preventDefault();
  });

  // 禁止 F12、Ctrl+Shift+I、Ctrl+U 等调试快捷键
  document.addEventListener("keydown", function (e) {
    // F12 键
    if (e.key === "F12") {
      e.preventDefault();
      showToast("禁止调试！");
    }
    // Ctrl+Shift+I
    if (e.ctrlKey && e.shiftKey && e.key === "I") {
      e.preventDefault();
      showToast("禁止调试！");
    }
    // Ctrl+U（查看源代码）
    if (e.ctrlKey && e.key === "u") {
      e.preventDefault();
      showToast("禁止查看源代码！");
    }
  });
});
