document.addEventListener("DOMContentLoaded", function () {
  const pageContainer = document.querySelector(".page-container");
  const urlParams = "{}";

  window.onload = onLoad;

  // 给「注册心火账号」按钮绑定点击事件
  document
    .getElementById("xh_register_btn")
    .addEventListener("click", function () {
      // 在当前窗口跳转（覆盖原页面，适合移动端）
      if (urlParams.userName && urlParams.passwd) {
        window.location.href = `login_xh.html?userName=${urlParams.userName}&passwd=${urlParams.passwd}&auto=0`;;
      } else{
        window.location.href = "login_xh.html";
      }
    });
  document
    .getElementById("facebook_register_btn")
    .addEventListener("click", function () {
      showToast("开发中,敬请期待");
    });
  document
    .getElementById("google_register_btn")
    .addEventListener("click", function () {
      showToast("开发中,敬请期待");
    });

  function onLoad() {
    // 获取URL参数
    urlParams = getUrlParams();
  }
    
  // 1. 解析URL参数的工具函数
  function getUrlParams() {
    const params = {};
    // 获取URL中?后的查询字符串
    const search = window.location.search.substring(1);
    if (!search) return params;

    // 分割参数并解析
    const paramArr = search.split("&");
    paramArr.forEach((item) => {
      const [key, value] = item.split("=");
      // 解码参数（处理中文/特殊字符）
      if (key) params[key] = decodeURIComponent(value || "");
    });
    return params;
  }

  // 提示框控制函数（复用，支持自定义文本）
  const toast = document.getElementById("toast");
  function showToast(text, duration = 2000) {
    toast.textContent = text; // 设置提示文本
    toast.classList.add("show"); // 显示提示框

    // 自动隐藏（duration 毫秒后，默认2秒）
    setTimeout(() => {
      toast.classList.remove("show");
    }, duration);
  }

  // 核心函数：计算并设置 viewport width 为 min(590, 100vw)
  function setViewportMinWidth() {
    const baseWidth = 590;
    const baseHeight = 610;
    const maxWidth1 = window.innerWidth;
    const maxWidth2 = (window.innerHeight * baseWidth) / baseHeight;
    const width = Math.min(baseWidth, Math.min(maxWidth1, maxWidth2));
    // 构造 viewport 配置（禁用缩放，避免干扰）
    const viewportContent = `width=${width}, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, user-scalable=no, viewport-fit=cover`;
    // 赋值给 viewport 标签
    document.getElementById("viewportMeta").content = viewportContent;
  }

  // 页面加载完成后执行
  window.addEventListener("load", setViewportMinWidth);
  // 窗口/ WebView 尺寸变化时实时更新（如旋转屏幕、调整 WebView 大小）
  window.addEventListener("resize", setViewportMinWidth);
  // 屏幕旋转后更新（兼容移动端）
  window.addEventListener("orientationchange", setViewportMinWidth);

// -------------- 禁用开发者工具 --------------
  // 禁止右键菜单（防止查看源代码）
  document.addEventListener('contextmenu', function(e) {
    e.preventDefault();
  });

  // 禁止 F12、Ctrl+Shift+I、Ctrl+U 等调试快捷键
  document.addEventListener('keydown', function(e) {
    // F12 键
    if (e.key === 'F12') {
      e.preventDefault();
      showToast('禁止调试！');
    }
    // Ctrl+Shift+I
    if (e.ctrlKey && e.shiftKey && e.key === 'I') {
      e.preventDefault();
      showToast('禁止调试！');
    }
    // Ctrl+U（查看源代码）
    if (e.ctrlKey && e.key === 'u') {
      e.preventDefault();
      showToast('禁止查看源代码！');
    }
  });

});
