document.addEventListener("DOMContentLoaded", function () {
  const pageContainer = document.querySelector(".page-container");
  const inputUserName = document.getElementById("username-input");
  const inputPassWd = document.getElementById("password-input");

  window.onload = onLoad;

  // 给「注册心火账号」按钮绑定点击事件
  document.getElementById("xh_back_btn").addEventListener("click", function () {
    // 在当前窗口跳转（覆盖原页面，适合移动端）
    window.location.href = "register.html";
  });

  document.getElementById("xh_login_btn").addEventListener("click", doLogin);

  document
    .getElementById("xh_register_btn")
    .addEventListener("click", function () {
      // 在当前窗口跳转（覆盖原页面，适合移动端）
      window.location.href = "register_xh.html";
    });

  inputUserName.addEventListener("input", function () {
    const isLegal = checkLenth(this.value, 0);
    if (!isLegal) {
      showToast("用户名需要输入3-20个字符");
    }
  });

  inputPassWd.addEventListener("input", function () {
    const isLegal = checkLenth(this.value, 0);
    if (!isLegal) {
      showToast("密码需要输入6-20个字符");
    }
  });

  function onLoad() {
    // 获取URL参数
    const urlParams = getUrlParams();

    // 获取页面中的input元素
    const userNameInput = document.getElementById("username-input");
    const passWdInput = document.getElementById("password-input");

    // 填充用户名（如果有参数）
    if (urlParams.userName) {
      userNameInput.value = urlParams.userName;
    }

    // 填充密码（如果有参数）
    if (urlParams.passwd) {
      passWdInput.value = urlParams.passwd;
    }

    // 设置自动登录复选框（auto=0 不勾选，auto=1 勾选）
    if (urlParams.auto === "1") {
      doLogin();
    }
  }

  async function doLogin() {
    // 显示遮罩层 + 屏蔽底层点击
    const maskLayer = document.getElementById("loginMask");
    maskLayer.style.display = "flex"; // 显示遮罩
    document.body.classList.add("mask-active"); // 屏蔽底层元素点击

    if (!checkLenth(inputUserName.value, 3)) {
      showToast("用户名需要输入6-20个字符");
      return;
    }

    if (!checkLenth(inputPassWd.value, 3)) {
      showToast("密码需要输入6-20个字符");
      return;
    }

    if (!checkStrValid(inputUserName.value)) {
      showToast("用户名只能输入数字和大小写字母");
      return;
    }

    if (!checkStrValid(inputPassWd.value)) {
      showToast("密码只能输入数字和大小写字母");
      return;
    }

    // 后端登录获取token
    LoginResult = await sendLoginRequest(
      inputUserName.value,
      inputPassWd.value
    );

    if (LoginResult.status == 0) {
      // showToast("Login Success");
      sendToUnity(inputUserName.value, inputPassWd.value, LoginResult.token, LoginResult.userId);
    } else {
      showToast(`Login Failed, ${LoginResult.message}`);
    }

    setTimeout(() => {
      maskLayer.style.display = "none";
      if (LoginResult.status == 0) {
        showToast("Login Success");
      } else {
        showToast(`Login Failed, ${LoginResult.message}`);
      }
      document.body.classList.remove("mask-active");
    }, 1000);

    // setTimeout(() => {
    //   maskLayer.style.display = "none";
    //   if (LoginResult.status == 0) {
    //     showToast("Login Success");
    //     sendToUnity(inputUserName.value, inputPassWd.value, LoginResult.token);
    //   } else{
    //     showToast(`Login Failed, ${LoginResult.message}`);
    //   }
    //   document.body.classList.remove("mask-active");
    // }, 500);
  }

  // 1. 解析URL参数的工具函数
  function getUrlParams() {
    const params = {};
    // 获取URL中?后的查询字符串
    const search = window.location.search.substring(1);
    if (!search) return params;

    // 分割参数并解析
    const paramArr = search.split("&");
    paramArr.forEach((item) => {
      const [key, value] = item.split("=");
      // 解码参数（处理中文/特殊字符）
      if (key) params[key] = decodeURIComponent(value || "");
    });
    return params;
  }

  // 检查字符串合法,只允许数字/a-z/A_Z
  function checkStrValid(value) {
    const reg = /^[0-9a-zA-Z]*$/;
    return reg.test(value);
  }

  // 检查长度
  function checkLenth(value, minLen) {
    if (!value.trim()) {
      return false;
    }

    if (value.length < minLen) {
      return false;
    } else if (value.length > 20) {
      return false;
    }
    return true;
  }

  // 向 Unity 发送消息（调用 Unity 的公开方法）
  // 核心：通过 uniwebview:// 协议发送（格式：uniwebview://[动作]?data=[JSON字符串]）
  // 注意:URL 需编码特殊字符（如 JSON 中的引号、逗号）
  function sendToUnity(user, passwd, token, userId) {
    try {
      let data1 = { name: user, passwd: passwd, token: token, userId:userId };
      const jsonStr = JSON.stringify(data1);
      const encodedData = encodeURIComponent(jsonStr);
      const url = `uniwebview://send?data=${encodedData}`;
      window.location.href = url; // 触发协议跳转（UniWebView 会拦截该 URL，不会真的跳转）
      // alert("第一种方法消息发送完成");
    } catch (e) {
      // alert("发送失败: " + (e.message || e));
    }
  }

  // 发送注册 GET 请求（核心）
  async function sendLoginRequest(user, passwd) {
    // 后端接口地址（替换为你的真实后端 URL）
    const urlBase = HttpUtils.baseUrl();
    const url = `${urlBase}user/login`;
    const params = {
      userName: encodeURIComponent(user),
      passwd: encodeURIComponent(passwd),
    };
    const responseJson = await HttpUtils.get(url, params);

    if (responseJson.status === 0) {
      const result = {
        status: 0,
        token: responseJson.token,
        userId: responseJson.userId
      };
      return result;
    }
    const result = { status: 1, message: responseJson.message };
    return result;
  }

  // 核心函数：计算并设置 viewport width 为 min(590, 100vw)
  function setViewportMinWidth() {
    const baseWidth = 590;
    const baseHeight = 610;
    const maxWidth1 = window.innerWidth;
    const maxWidth2 = (window.innerHeight * baseWidth) / baseHeight;
    const width = Math.min(baseWidth, Math.min(maxWidth1, maxWidth2));
    // 构造 viewport 配置（禁用缩放，避免干扰）
    const viewportContent = `width=${width}, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, user-scalable=no, viewport-fit=cover`;
    // 赋值给 viewport 标签
    document.getElementById("viewportMeta").content = viewportContent;
    // console.log('当前 viewport 宽度:', width);
  }

  // 页面加载完成后执行
  window.addEventListener("load", setViewportMinWidth);
  // 窗口/ WebView 尺寸变化时实时更新（如旋转屏幕、调整 WebView 大小）
  window.addEventListener("resize", setViewportMinWidth);
  // 屏幕旋转后更新（兼容移动端）
  window.addEventListener("orientationchange", setViewportMinWidth);

  // 提示框控制函数（复用，支持自定义文本）
  const toast = document.getElementById("toast");
  function showToast(text, duration = 2000) {
    toast.textContent = text; // 设置提示文本
    toast.classList.add("show"); // 显示提示框

    // 自动隐藏（duration 毫秒后，默认2秒）
    setTimeout(() => {
      if (toast.classList.contains("show")) {
        toast.classList.remove("show");
      }
    }, duration);
  }

  // -------------- 禁用开发者工具 --------------
  // 禁止右键菜单（防止查看源代码）
  document.addEventListener("contextmenu", function (e) {
    e.preventDefault();
  });

  // 禁止 F12、Ctrl+Shift+I、Ctrl+U 等调试快捷键
  document.addEventListener("keydown", function (e) {
    // F12 键
    if (e.key === "F12") {
      e.preventDefault();
      showToast("禁止调试！");
    }
    // Ctrl+Shift+I
    if (e.ctrlKey && e.shiftKey && e.key === "I") {
      e.preventDefault();
      showToast("禁止调试！");
    }
    // Ctrl+U（查看源代码）
    if (e.ctrlKey && e.key === "u") {
      e.preventDefault();
      showToast("禁止查看源代码！");
    }
  });
});
