// http-utils.js（公用 HTTP 工具类）
const HttpUtils = {

  baseUrl(){
    return "https://hwapi.xhhycd.com/sdk/";
    // return "http://127.0.0.1:12345/";
  },

  /*发送GET请求, 返回解析后的 JSON 响应数据*/
  async get(url, params = {}) {
    try {
      const urlParams = new URLSearchParams();
      Object.entries(params).forEach(([key, value]) => {
        if (value !== undefined && value !== null) {
          urlParams.append(key, encodeURIComponent(value));
        }
      });

      const requestUrl = `${url}?${urlParams.toString()}`;
      const response = await fetch(requestUrl, {
        method: "GET",
        mode: "cors",
        headers: {
          "Content-Type": "application/x-www-form-urlencoded"
        },
        timeout: 10000
      });

      if (!response.ok) {
         return {"status":1, "msg":"network error, please check..."}
      }

      // 5. 解析 JSON 并返回
      const jsonData = await response.json();
      return jsonData; // 成功时返回解析后的 JSON

    } catch (error) {
       return {"status":1, "msg": error.toString()}
    }
  }

};

// 暴露全局变量，方便其他文件调用（无需 import/export，适配原生 JS）
window.HttpUtils = HttpUtils;